state WinterSoulsSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;

	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("magic_man_mage.bnk") )
		{
			theSound.SoundLoadBank( "magic_man_mage.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("ep2_mutations_06.bnk") )
		{
			theSound.SoundLoadBank( "ep2_mutations_06.bnk", false );
		}
	
		//if ( parent.spell_name == 'winter_souls_tornado' )
		//{
		//	thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		//}
		//else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		if ( animEventName == 'cast_throw' )
		{
			cast_spells_winter();
			if ( parent.spell_name != 'winter_souls_tornado' )
			{
				thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
			}
		}
		if ( animEventName == 'cast_end' )
		{
			cast_spells_winter_tornado();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_winter()
	{
		var basePos, pos			: Vector;
		var rot 					: EulerAngles;
		var spikeEnt				: CEntity;
		var PositionLocal			: Vector;
		var PositionGlobal			: Vector;
		var polarAngle, unitAngle 	: float;
		var radius, angle		 	: float;
		
		switch( parent.spell_name )
		{
			case 'winter_souls_shield':
				{
					clear_guarding_buffs( false );
				
					CustomEffect.effectType = EET_Wintershield;
					CustomEffect.creator = GetWitcherPlayer();
					CustomEffect.duration = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'shield_duration', true, true) );
					GetWitcherPlayer().AddEffectCustom( CustomEffect );
					thePlayer.PlayEffect('mutation_1_aard_power');
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'winter_souls_stream':
				{
					parent.templatename = "dlc\magicspellsrev\data\entities\wintersouls.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), thePlayer.GetWorldPosition() );
					main_effect.PlayEffect('winter_souls_stream');
					main_effect.CreateAttachment( thePlayer, 'l_weapon');
					main_effect.AddTag('spells_alt_stream');
					
					parent.stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_cost_per_sec', false, true ) * 0.5 );
					parent.stamina_cost += parent.stamina_cost * get_stamina_cost_mult_streams(); 
					
					parent.stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_delay', false, true ) );
					parent.stamina_delay += parent.stamina_delay * get_stamina_delay_mult(); 
					
					register_cancel_input_spells();
					
					parent.stream_hits.Clear();
					
					cast_spells_stream_winter();
				}

				break;
			case 'winter_souls_blast':
				{
					
					position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward();
					position = TraceFloor( position );
					position.Z += 1.5;
					
					parent.templatename = "dlc\magicspellsrev\data\entities\wintersouls.w2ent";
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, thePlayer.GetWorldRotation() );
					main_effect.PlayEffect( 'winter_souls_blast' );
					main_effect.PlayEffect( 'winter_souls_blast_light' );
					main_effect.DestroyAfter(10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\wintesouls_blast.w2ent";
					//position.Z -= 3;
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, thePlayer.GetWorldRotation() );
					main_effect.PlayEffect( 'blast_lv2' );
					main_effect.DestroyAfter(10);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
					thePlayer.PlayEffect('mutation_1_aard_power');
					thePlayer.SoundEvent('ep2_mutations_06_frosty_aard');
					
					theGame.GetSurfacePostFX().AddSurfacePostFXGroup( TraceFloor( position ), 1.f, 15, 2.f, 25.f, 0);
					
					GCameraShake( 0.4, true, position, 30.0f);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\wintersouls_ice_spikes_blast.w2ent";
					spikeEnt = theGame.CreateEntity( (CEntityTemplate) LoadResource( parent.templatename, true ), TraceFloor( position ), thePlayer.GetWorldRotation() );
					spikeEnt.StopAllEffects();
					spikeEnt.DestroyAfter( 20.f );
					
					FindGameplayEntitiesInRange( entities, thePlayer, 8, 100 );
					for ( i = 0; i <= entities.Size(); i+=1 )
					{
						if ( !entities[i].HasTag('spells_custom_projs') )
						{
							entities[i].OnAardHit( NULL );
						}
					}
					
					actors = thePlayer.GetNPCsAndPlayersInRange( 8, 100, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
					for( i = 0; i < actors.Size(); i += 1 )
					{
						target = (CActor)actors[i];
						damage_value = get_damage_value_for_blasts( target, GetMagicVigil().get_magic_spellpower() );
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitReactionType(EHRT_Heavy);
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage_value );
						if( RandF() < 0.2 ) 
						{ 
							damage_action.AddEffectInfo( EET_Frozen, 3 ); 
						}
						else
						{
							damage_action.AddEffectInfo( EET_Stagger );
							damage_action.AddEffectInfo( EET_SlowdownFrost, MaxF( 3, MinF( 8, get_spellpower_spells( false, S_Magic_1 )*3 ) ) );
						}
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						effect_entity = target.CreateFXEntityAtPelvis( 'wintersouls_effects', true );
						effect_entity.PlayEffect( 'wintersouls_flame' );
						effect_entity.DestroyAfter(5);
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
				}
				
				break;
			case 'winter_souls_cone':
				{
					thePlayer.SoundEvent('ep2_mutations_06_frosty_aard');
				
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = MatrixGetRotation(slotMatrix);
						
					rotation.Roll = ClampF(rotation.Roll,-100,10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\wintersouls.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					main_effect.PlayEffect('winter_souls_cone');
					main_effect.DestroyAfter(10);
					
					FindGameplayEntitiesInCone(entities, thePlayer.GetWorldPosition(), VecHeading( thePlayer.GetHeadingVector() ), 80, 5, 100);
					for( i = 0; i < entities.Size(); i += 1 )   
					{
						if ( !entities[i].HasTag('spells_custom_projs') )
						{
							entities[i].OnAardHit( NULL );
						}
					}
					
					actors = thePlayer.GetNPCsAndPlayersInCone(5, VecHeading(thePlayer.GetHeadingVector()), 80, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
					for( i = 0; i < actors.Size(); i += 1 )
					{
						target = (CActor)actors[i];
						
						damage_value = get_damage_value_for_cone( target, GetMagicVigil().get_magic_spellpower() );
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitReactionType(EHRT_Heavy);
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage_value );
						damage_action.AddEffectInfo( EET_SlowdownFrost, MaxF( 3, MinF( 8, get_spellpower_spells( false, S_Magic_1 )*3 ) ) );
						
						effect_entity = target.CreateFXEntityAtPelvis( 'wintersouls_effects', true );
						effect_entity.PlayEffect( 'wintersouls_flame' );
						effect_entity.DestroyAfter(5);
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}
				
				break;
			default:		
				break;
		}
	}
	
	private function cast_spells_winter_tornado()
	{
		var tornado 	: W3RimrgandMouth;
	
		if ( parent.spell_name == 'winter_souls_tornado' )
		{
			theGame.GetEntitiesByTag('winter_souls_tornado_spells',ents_destroy);
			for( i=0; i<ents_destroy.Size(); i+=1 )
			{
				ents_destroy[i].AddTimer('destroy_winter_mouth',0.0f);
			} 	
			
			parent.templatename = "dlc\magicspellsrev\data\entities\wintersouls_tornado.w2ent";
		
			duration = 10;
			duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
		
			position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*6;
		
			position = find_position_spells( position );
		
			tornado = (W3RimrgandMouth)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), thePlayer.GetWorldRotation());
			tornado.AddTimer('destroy_winter_mouth', duration );
			tornado.AddTag('winter_souls_tornado_spells');
			tornado.AddTag( 'spells_from_sign' );
			
			theGame.GetSurfacePostFX().AddSurfacePostFXGroup( TraceFloor( position ), 1.f, duration, 1.f, 20.f, 0);
			
			Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
		}
	}
		
		
	private entry function cast_spells_stream_winter()
	{
		var damage_action_stream				: W3DamageAction;
		var victims 							: array<CActor>;
		var victim								: CActor;
		var damage 								: float;
		var channelDmg 							: SAbilityAttributeValue;
		var i									: int;
		var castDir								: Vector;
		var targetPosition						: Vector;
		var position							: Vector;
		var slotMatrix 							: Matrix;
		var effectentity						: CEntity;
		var coll, normal 						: Vector;
		var lastpos 							: Vector;
		var lastpos2 							: Vector;
		var entities							: array<CGameplayEntity>;
		
		while ( true )
		{
			if (  thePlayer.GetStatPercents( BCS_Stamina ) > 0.01f && thePlayer.GetBehaviorVariable	( 'IsCastingSign' ) == 1 )
			{
				thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
				position = MatrixGetTranslation(slotMatrix);
				
				castDir 		= MatrixGetAxisX( thePlayer.GetBoneWorldMatrixByIndex( thePlayer.GetBoneIndex( 'l_weapon' ) ) );
				targetPosition  = position + ( 6 * castDir );
				
				parent.hand_aim_position = position;
				parent.hand_aim_direction = castDir;
			
				FindGameplayEntitiesInCone( entities, position, VecHeading( castDir ), 25, 6, 100 );
			
				for (i=0; i<entities.Size(); i+=1)			
				{
					if ( !parent.stream_hits.Contains( entities[i] ) && !entities[i].HasTag('spells_custom_projs') )
					{
						entities[i].OnAardHit( NULL );
						parent.stream_hits.PushBack( entities[i] );
					}
				}
			
				victims = thePlayer.GetNPCsAndPlayersInCone( 6, VecHeading( castDir ), 25, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
				for (i=0; i<victims.Size(); i+=1)			
				{
					victim = (CActor)victims[i];
					if ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive() )
					{
						damage = get_damage_value_for_stream( victim, GetMagicVigil().get_magic_spellpower() );
						damage *= theTimer.timeDelta;
					
						damage_action_stream = new W3DamageAction in this;
						damage_action_stream.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_SpellPower,false, false, true, false );
						damage_action_stream.SetProcessBuffsIfNoDamage(true);
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							damage *= 0.5;
						
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 3 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						else
						{
							if( RandF()<0.1 ) { damage_action_stream.AddEffectInfo( EET_Frozen, 2 ); }
						}
						
						damage_action_stream.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage );
						damage_action_stream.AddEffectInfo( EET_SlowdownFrost, 3 );
						
						damage_action_stream.SetIsDoTDamage( theTimer.timeDelta );
							
						damage_action_stream.SetHitAnimationPlayType(EAHA_ForceNo);
						damage_action_stream.SetHitEffect('');
						damage_action_stream.SetHitEffect('', true );
						damage_action_stream.SetHitEffect('', false, true);
						damage_action_stream.SetHitEffect('', true, true);
						
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action_stream.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action_stream );
						delete damage_action_stream;
					}
				}
				
				if( theGame.GetWorld().SweepTest( position + castDir, targetPosition, 0.3, coll, normal, parent.collisions_stream ) )
				{
					lastpos = coll;
					theGame.GetEntityByTag( 'spells_stream_collision' ).PlayEffectSingle('collision_fx');
					
					if ( VecDistance( lastpos2, coll ) > 0.3 )
					{
						lastpos2 = coll;
						theGame.GetSurfacePostFX().AddSurfacePostFXGroup( lastpos2, 0.3f, 8.0f, 1.0f, 6.0f, 0 );
					}
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).StopAllEffects();
				}
				
				if ( !theGame.GetEntityByTag( 'spells_stream_collision' ) )
				{
					effectentity = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\wintersouls_stream_collision.w2ent",true), targetPosition, thePlayer.GetWorldRotation() );
					effectentity.AddTag('spells_stream_collision');
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(lastpos);
				}
				
				GetWitcherPlayer().DrainStamina( ESAT_FixedValue, parent.stamina_cost * theTimer.timeDelta, parent.stamina_delay ); 
			}
			else
			{
				thePlayer.SoundEvent("gui_no_stamina");
				parent.PushState('Vigil_Dreaming');
			}
			
			Sleep( theTimer.timeDelta );
		}
	
	}
	
	
	event OnLeaveState( nextStateName : name )
	{
	}
}